﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
    <HEAD>
        <title>Specyfikacja eksportowa</title>
        <script runat="server">

            ParametryWydrukuDokumentuTransport parametry;
            // [Context] // narazie bez parametrów, ale wszystko wskazuje na to ze kiedyś to będzie potrzebne ... 
            public ParametryWydrukuDokumentuTransport Parametry {
                get { return parametry; }
                set { parametry = value; }
            }


            DokumentHandlowy dokument;
            [Context]
            public DokumentHandlowy DokumentHandlowy {
                get { return dokument; }
                set { dokument = value; }
            }
    
            
    void OnContextLoad(Object sender, EventArgs args) {        
                        
        parametry = new ParametryWydrukuDokumentuTransport((sender as DataContext).Context);                
        DataRepeater1.DataSource = (IEnumerable)Parametry;            

        SectionDokumentHandlowy.Visible = dokument.DokumentHandlowyNumer!="";
        SectionMagazyn.Visible = dokument.Magazyn!=null && dokument.MagazynDo==null;       
    
        //Formatujemy informację o podmiocie
        
        if (dokument.Kontrahent==null)
            SectionKontrahent.Visible = false;
        else {
            kto2.EditValue = "Odbiorca / Recipient";
        }
    
        //Składamy opis do dokumentu
        string opis = "";
        bool jestOpis = false;
        if (dokument.Opis != "")
        {
            opis += "<p> Opis / <i>Description:</i><br />" + dokument.Opis + "</p>";
            jestOpis = true;
        }

        if (dokument.Wydruk.OpisWydruku != "")
        {
            opis += jestOpis ? 
                "<p>" + dokument.Wydruk.OpisWydruku + "</p>" :
                "<p> Opis / <i>Description:</i><br />" + dokument.Wydruk.OpisWydruku + "</p>";
        }
 
        Opis.EditValue = opis;
        
        stPodpis.Caption = "<font size=2>"+dokument.Session.Login.Operator.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
        stOsoba.Caption = "<font size=2>" + dokument.Osoba + "</font><br><br><font size=1>..................................................<br>Podpis odbiorcy. Imie i nazwisko<br /><i>Name of a person authorized to receive goods</i></font>" + parametry.Kierowca;
    }
    
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        //Formatujemy nagłówek dokumentu.
        //Może być za każdym razem inny
        KopiaDokumentuTransport kopia = (KopiaDokumentuTransport)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        //string title = dokument.Definicja.TytulWydruku;
        string title = String.Format("<span style='font-size: 16px;'>Specyfikacja eksportowa {0}</span>", dokument.Numer);
        title += String.Format("|<i><span style='font-size: 16px;'>Export specification {0}<span></i>", dokument.Numer);

        title += "</STRONG>";
            
        title += String.Format("|<span style='font-size: 13px;'>Data i miejsce wystawienia: <STRONG> {0}, {1}</STRONG></span>", dokument.Data, 
            dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : 
            CoreModule.GetInstance(dokument).Config.Firma.AdresSiedziby.Miejscowosc);

        title += String.Format("|<i><span style='font-size: 13px;'>Date / place of issue: <STRONG> {0}, {1}</STRONG></span></i>", dokument.Data,
            dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc :
            CoreModule.GetInstance(dokument).Config.Firma.AdresSiedziby.Miejscowosc);        

                
        // title += "|</STRONG>Data operacji:<STRONG> " + dokument.DataOperacji;                
        //if (kopia.Kopia==TypKopiiDokumentuTransport.Duplikat)
        //  title += "|</STRONG>Data wystawienia duplikatu:<STRONG> " + Date.Today;


        if (dokument.Wydruk.OpisStanu != "")
            title += "|" + dokument.Wydruk.OpisStanu;
        
        ReportHeader1.Title = title;
    }
    
        </script>
        <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
        <meta content="C#" name="CODE_LANGUAGE">
        <meta content="JavaScript" name="vs_defaultClientScript">
        <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    </HEAD>
    <body>
        <form id="Sprzedaż" method="post" runat="server">
            <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"></ea:datacontext>
            <ea:datarepeater id="DataRepeater1" runat="server" Height="397px" Width="100%" RowTypeName="Soneta.Handel.KopiaDokumentu,Soneta.Handel"
                OnBeforeRow="DataRepeater1_BeforeRow">

                <ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
                <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
                <cc1:ReportHeader id="ReportHeader1" title="Specyfikacja Transportowa" runat="server"></cc1:ReportHeader>
                
                <ea:Section id="SectionDokumentHandlowy" runat="server" Width="100%">
                    <EM>
                        Dokument handlowy / Invoice : </EM>
                    <ea:DataLabel id="DataLabel11" runat="server" DataMember="Dokument.DokumentHandlowyNumer"  EncodeHTML="True"></ea:DataLabel>
                    <EM>&nbsp;z dnia / of :</EM>
                    <ea:DataLabel id="DataLabel13" runat="server" DataMember="Dokument.DokumentHandlowyData" EncodeHTML="True"></ea:DataLabel>
                    <br />
                </ea:Section>


                <ea:Section id="SectionMagazyn" runat="server" Width="100%">
                    <EM>Magazyn: </EM>
                    <ea:DataLabel id="DataLabel1" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>					
                </ea:Section>

                <ea:Section id="SectionKontrahent" runat="server" Width="100%">
                    <EM>
                        <TABLE id="Table1" cellSpacing="0" width="100%">
                            <TR>
                                <TD vAlign="top" width="50%"><EM><U>
                                            <ea:DataLabel id="kto2" runat="server" Bold="False" Font-Italic="True" EncodeHTML="True"></ea:DataLabel>:<BR>
                                        </U></EM>
                                    <DIV style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
                                        <ea:DataLabel id="DataLabel4" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><BR>
                                        <ea:DataLabel id="DataLabel5" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><BR>
                                        <ea:DataLabel id="DataLabel6" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><BR>
                                        NIP:
                                        <ea:DataLabel id="DataLabel12" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.EuVAT"></ea:DataLabel></DIV>
                                </TD>
                                <TD vAlign="top" width="100%">
                                    <ea:Section id="sectionOdbiorca" runat="server" DataMember="Dokument.Wydruk.JestOdbiorca">
                                        <EM><U>
                                                <ea:DataLabel id="kto" runat="server" Bold="False" Font-Italic="True" DataMember="Dokument.Definicja.DostawcaOdbiorca" EncodeHTML="True"></ea:DataLabel>:</U></EM>
                                        <DIV style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
                                            <ea:DataLabel id="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><BR>
                                            <ea:DataLabel id="DataLabel9" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><BR>
                                            <ea:DataLabel id="DataLabel8" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><BR>
                                            NIP:
                                            <ea:DataLabel id="DataLabel7" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.EuVAT"></ea:DataLabel></DIV>
                                    </ea:Section>
                                    <ea:Section id="sectionMiejsceDostawy" runat="server" DataMember="Dokument.Wydruk.JestOdbiorcaMiejsceDostawy">
                                        <em style="text-decoration: underline;">Miejsce dostawy:</em>
                                        <div style="font-size: 13px; left: 10px; font-family: tahoma; position: relative">
                                            <ea:DataLabel runat="server" DataMember="Dokument.OdbiorcaMiejsceDostawy.Nazwa" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
                                            <ea:DataLabel runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
                                        </div>
                                    </ea:Section>
                                </TD>
                            </TR>
                        </TABLE>
                    </EM>
                </ea:Section>

                <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                    DataMember="Dokument.Pozycje" RowsInRow="2">
                    <Columns>
                        <ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp.|&lt;i&gt;#&lt;/i&gt;" RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn2" Width="15" DataMember="Towar.Kod" Caption="Kod towaru|&lt;i&gt;Item code&lt;/i&gt;" RowSpan="2" EncodeHTML="True" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn3" DataMember="NazwaPierwszaLinia" Caption="Nazwa towaru/usługi|&lt;i&gt;Product/service description&lt;/i&gt;" EncodeHTML="True" runat="server" RowSpan="2"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn5" Width="10" RightBorder="None" Align="Right" DataMember="ZmianaIlości.Value" Caption="Ilość|&lt;i&gt;Quantity&lt;/i&gt;" RowSpan="2" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn6" Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm.|&lt;i&gt;unit&lt;/i&gt;" RowSpan="2" runat="server"></ea:GridColumn>


                        <ea:GridColumn ID="GridColumn4" runat="server" Caption="Kod CN|&lt;i&gt;CN code&lt;/i&gt;" DataMember="Towar.KodCN" RowSpan="2" Width="14" Align="Center"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Masa netto|&lt;i&gt;Net weight&lt;/i&gt;" DataMember="MasaNetto" EncodeHTML="True" RowSpan="2" Total="Sum" Align="Center" Width="12"></ea:GridColumn>
                        <ea:GridColumn runat="server" Caption="Masa brutto|&lt;i&gt;Gross weight&lt;/i&gt;" DataMember="MasaBrutto" EncodeHTML="True" RowSpan="2" Width="12" Total="Sum" Align="Center"></ea:GridColumn>
                    </Columns>
                </ea:Grid>
                    <br />
                    Podsumowanie ilości:
                    <ea:DataLabel id="DataLabel14" runat="server" Bold="False" DataMember="Dokument.Wydruk.PodsumowanieIlości">
                    </ea:DataLabel>
                    <br />
                    <i>Total quantity</i>

                    <ea:DataLabel id="Opis" runat="server" Bold="False"></ea:DataLabel>
                    <br />
                    <br />
                
                    Kwituję odbiór towaru w ilości wg powyższej specyfikacji<br />
                    <i>Acknowledgment of receipt</i><br />

                    <cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
                        <Subtitles>
                            <cc1:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                            <cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
                        </Subtitles>
                    </cc1:ReportFooter>
                
                <ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>

            </ea:datarepeater>
        </form>
    </body>
</HTML>

